#!/usr/bin/env bash
set -e

APPIMAGE_NAME="EMB_Tools.AppImage"

ICON_B64='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'

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
APPIMAGE_SRC="$SCRIPT_DIR/$APPIMAGE_NAME"

if [[ ! -f "$APPIMAGE_SRC" ]]; then
  echo "Error: $APPIMAGE_NAME not found next to the installer."
  exit 1
fi

if ! command -v apt >/dev/null 2>&1; then
  echo "Error: this installer is for Debian/Ubuntu systems with apt."
  exit 1
fi

echo "Updating package lists and installing dependencies..."
sudo apt update
sudo apt install -y libfuse2 xdg-user-dirs policykit-1 || sudo apt install -y libfuse2t64 xdg-user-dirs policykit-1

APPS_DIR="$HOME/Applications"
mkdir -p "$APPS_DIR"

echo "Copying AppImage to $APPS_DIR..."
cp "$APPIMAGE_SRC" "$APPS_DIR/$APPIMAGE_NAME"
chmod +x "$APPS_DIR/$APPIMAGE_NAME"

ICON_PATH="$APPS_DIR/embtools.png"
echo "Restoring embedded icon to $ICON_PATH..."
echo "$ICON_B64" | base64 -d > "$ICON_PATH"

xdg-user-dirs-update >/dev/null 2>&1 || true

DESKTOP_CANDIDATES=()
if DESK_FROM_XDG="$(xdg-user-dir DESKTOP 2>/dev/null)"; then
  DESKTOP_CANDIDATES+=("$DESK_FROM_XDG")
fi
DESKTOP_CANDIDATES+=("$HOME/Desktop" "$HOME/Рабочий стол")

DESKTOP_DIR=""
for d in "${DESKTOP_CANDIDATES[@]}"; do
  [[ -z "$d" ]] && continue
  if [[ -d "$d" ]]; then
    DESKTOP_DIR="$d"
    break
  fi
done

if [[ -z "$DESKTOP_DIR" ]]; then
  DESKTOP_DIR="$HOME/Desktop"
  mkdir -p "$DESKTOP_DIR"
fi

mkdir -p "$HOME/.local/share/applications"

DESKTOP_FILE="$HOME/.local/share/applications/embtools-root.desktop"

cat > "$DESKTOP_FILE" <<EOF
[Desktop Entry]
Type=Application
Name=EMB Tools
Comment=VPN client and security toolkit (run as administrator)
Exec=sh -c 'pkexec env DISPLAY=\$DISPLAY XAUTHORITY=\$XAUTHORITY WAYLAND_DISPLAY=\$WAYLAND_DISPLAY "$APPS_DIR/$APPIMAGE_NAME"'
Icon=$ICON_PATH
Terminal=false
Categories=Network;Security;
StartupWMClass=EMBTools
EOF

chmod +x "$DESKTOP_FILE"

DESKTOP_SHORTCUT="$DESKTOP_DIR/EMB Tools.desktop"
cp "$DESKTOP_FILE" "$DESKTOP_SHORTCUT"
chmod +x "$DESKTOP_SHORTCUT"

if command -v gio >/dev/null 2>&1; then
  gio set "$DESKTOP_SHORTCUT" metadata::trusted true 2>/dev/null || true
fi

echo
echo "==========================================="
echo "EMB Tools installation finished."
echo "AppImage: $APPS_DIR/$APPIMAGE_NAME"
echo "Icon:     $ICON_PATH"
echo "Desktop shortcut: $DESKTOP_SHORTCUT"
echo "Launch from the desktop icon, you will be asked for the admin password (pkexec)."
echo "==========================================="

